/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.Constant;
import com.ibm.hwmca.fw.util.HexString;

public class NumericConstant
extends Constant {
    protected NumericConstant(Number value) {
        super(value);
    }

    protected NumericConstant(byte value) {
        this(new Byte(value));
    }

    protected NumericConstant(short value) {
        this(new Short(value));
    }

    protected NumericConstant(int value) {
        this(new Integer(value));
    }

    protected NumericConstant(long value) {
        this(new Long(value));
    }

    public NumericConstant(byte[] byteArray) {
        super(null);
        if (byteArray != null) {
            long value = 0L;
            int length = byteArray.length;
            if (length > 8) {
                length = 8;
            }
            for (int ix = 0; ix < length; ++ix) {
                value <<= 8;
                value |= 0xFFL & (long)byteArray[ix];
            }
            if (length == 1) {
                this.setValue(new Byte((byte)value));
            } else if (length == 2) {
                this.setValue(new Short((short)value));
            } else if (length <= 4) {
                this.setValue(new Integer((int)value));
            } else {
                this.setValue(new Long(value));
            }
        }
    }

    public byte byteValue() {
        byte result = 0;
        Number value = (Number)this.getValue();
        if (value != null) {
            result = value.byteValue();
        }
        return result;
    }

    public short shortValue() {
        short result = 0;
        Number value = (Number)this.getValue();
        if (value != null) {
            result = value.shortValue();
        }
        return result;
    }

    public int intValue() {
        int result = 0;
        Number value = (Number)this.getValue();
        if (value != null) {
            result = value.intValue();
        }
        return result;
    }

    public long longValue() {
        long result = 0L;
        Number value = (Number)this.getValue();
        if (value != null) {
            result = value.longValue();
        }
        return result;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[]{};
        Number value = (Number)this.getValue();
        if (value != null) {
            result = BinaryNumber.fromNumber(value);
        }
        return result;
    }

    public String toString() {
        Object value = this.getValue();
        String result = this.getName() + "[" + value;
        if (value != null) {
            result = result + " 0x" + this.toHexString();
        }
        result = result + "]";
        return result;
    }

    public String toString(boolean displayName, boolean displayDecimal, boolean displayHex) {
        boolean displayBrackets;
        StringBuffer result = new StringBuffer();
        Object value = this.getValue();
        if (displayName) {
            result.append(this.getName());
        }
        boolean bl = displayBrackets = displayName && (displayDecimal || displayHex) || !displayName && displayDecimal && displayHex && value != null;
        if (displayBrackets) {
            result.append("[");
        }
        if (value == null && (displayDecimal || displayHex)) {
            result.append("null");
        } else {
            if (displayDecimal) {
                result.append(this.getValue().toString());
                if (displayHex) {
                    result.append(" ");
                }
            }
            if (displayHex) {
                result.append("0x").append(this.toHexString());
            }
        }
        if (displayBrackets) {
            result.append("]");
        }
        return result.toString();
    }

    public String toHexString() {
        String result = "";
        Number value = (Number)this.getValue();
        if (value != null) {
            result = HexString.toHex(value, true);
        }
        return result;
    }
}

